(* Samuele Giraudo
 * 2024-10, 2024-11
 *)

type directions =
    |Up
    |Down
    |Left
    |Right

let random_direction () =
    match Random.int 4 with
        |0 -> Up
        |1 -> Down
        |2 -> Left
        |_ -> Right

let adjacent_square sq dir =
    let (dx, dy) =
        match dir with
            |Up -> (0, 1)
            |Down -> (0, -1)
            |Left -> (-1, 0)
            |Right -> (1, 0)
    in
    Squares.make (dx + Squares.x_coordinate sq) (dy + Squares.y_coordinate sq)

let build_random n =
    let rec aux n sq p =
        if n = 0 then
            p
        else
            let sq' = adjacent_square sq (random_direction ()) in
            if Polyominos.is_filled_square sq' p then
                aux n sq' p
            else
                let p' = Polyominos.add_square sq' p in
                aux (n - 1) sq' p'
    in
    aux (n - 1) Squares.origin Polyominos.origin

