(* Samuele Giraudo
 * 2024-10, 2024-11
 *)

module Squares = PolyominoGenerator.Squares
module Polyominos = PolyominoGenerator.Polyominos
module RandomGenerations = PolyominoGenerator.RandomGenerations

let () =
    let argc = Array.length Sys.argv in
    try
        let area = Array.get Sys.argv 1 |> int_of_string in

        let seed =
            if argc = 2 then
                (Unix.time () |> int_of_float) mod 1048576
            else
                Array.get Sys.argv 2 |> int_of_string
        in
        Random.init seed;
        let poly = RandomGenerations.build_random area in
        let prolog_str =
            Printf.sprintf
                "/*\nArea: %d\nSeed: %d\n*/\n\n%s\n"
                area
                seed
                (Polyominos.to_prolog poly)
        in
        print_endline prolog_str;
        let out = open_out "Prolog/Polyomino.pl" in
        output_string out prolog_str;
        close_out out;
    with
        |_ -> print_endline "Error: usage AREA [SEED].";
    ()

