% Samuele Giraudo
% 2024-11

:- use_module(library(clpfd)).

:- consult("Polyomino.pl").

add_squares(S1, S2, S3) :-
    S1 = square(X1, Y1),
    S2 = square(X2, Y2),
    S3 = square(X3, Y3),
    X3 #= X1 + X2,
    Y3 #= Y1 + Y2.

neighbor_north(S1, S2) :-
    add_squares(S1, square(0, 1), S2).

neighbor_south(S1, S2) :-
    add_squares(S1, square(0, -1), S2).

neighbor_east(S1, S2) :-
    add_squares(S1, square(1, 0), S2).

neighbor_west(S1, S2) :-
    add_squares(S1, square(-1, 0), S2).

neighbor(S1, S2) :-
    neighbor_north(S1, S2).
neighbor(S1, S2) :-
    neighbor_south(S1, S2).
neighbor(S1, S2) :-
    neighbor_east(S1, S2).
neighbor(S1, S2) :-
    neighbor_west(S1, S2).

filled_neighbor(S1, S2) :-
    neighbor(S1, S2),
    filled(S2).

filled_list([]).
filled_list([S | P]) :-
    filled_list(P),
    filled(S).

pattern_position(P, S) :-
    filled(S),
    maplist(add_squares(S), P, P1),
    filled_list(P1).

area(A) :-
    findall([S], pattern_position([square(0, 0)], S), S_LST),
    length(S_LST, A).

diagonal_pattern_position(S) :-
    pattern_position([square(0, 0), square(1, 1)], S).

anti_diagonal_pattern_position(S) :-
    pattern_position([square(0, 0), square(-1, 1)], S).

domino_pattern_position(S) :-
    pattern_position([square(0, 0), square(1, 0)], S).

anti_domino_pattern_position(S) :-
    pattern_position([square(0, 0), square(0, 1)], S).

elementary_path(S, S, POSSIBLE_SQUARES, [S]) :-
    member(S, POSSIBLE_SQUARES).
elementary_path(S_START, S_END, POSSIBLE_SQUARES, [S_START | PATH]) :-
    filled_neighbor(S_START, S),
    member(S, POSSIBLE_SQUARES),
    select(S_START, POSSIBLE_SQUARES, POSSIBLE_SQUARES_2),
    elementary_path(S, S_END, POSSIBLE_SQUARES_2, PATH).

elementary_path(S_START, S_END, PATH) :-
    findall(S, filled(S), POSSIBLE_SQUARES),
    elementary_path(S_START, S_END, POSSIBLE_SQUARES, PATH).

print_information :-
    % Area.
    area(AREA),
    format("Area: ~d\n", [AREA]),

    % Number of domino patterns.
    findall(S, domino_pattern_position(S), S_LST_DOMI),
    length(S_LST_DOMI, LEN_DOMI),
    format("Domino patterns: ~d\n", [LEN_DOMI]),

    % Number of anti-domino patterns.
    findall(S, anti_domino_pattern_position(S), S_LST_ADOMI),
    length(S_LST_ADOMI, LEN_ADOMI),
    format("Anti-domino patterns: ~d\n", [LEN_ADOMI]),

    % Number of diagonal patterns.
    findall(S, diagonal_pattern_position(S), S_LST_DIAGS),
    length(S_LST_DIAGS, LEN_DIAGS),
    format("Diagonal patterns: ~d\n", [LEN_DIAGS]),

    % Number of anti-diagonal patterns.
    findall(S, anti_diagonal_pattern_position(S), S_LST_ADIAGS),
    length(S_LST_ADIAGS, LEN_ADIAGS),
    format("Anti-diagonal patterns: ~d\n", [LEN_ADIAGS]),

    % Number of paths from the origin.
    findall([PATH2], elementary_path(square(0, 0), _, PATH2), PATH_LST2),
    length(PATH_LST2, LEN_PATHS2),
    format("Paths from the origin: ~d\n", [LEN_PATHS2]).

