open OUnit2
open CellularAutomata

let suite_tools =
    "Tools"
    >::: [
        "interval 0 8"
        >:: (fun _ -> assert_equal [0; 1; 2; 3; 4; 5; 6; 7; 8] (Tools.interval 0 8));
        "interval 2 5"
        >:: (fun _ -> assert_equal [2; 3; 4; 5] (Tools.interval 2 5));
        "interval 3 3"
        >:: (fun _ -> assert_equal [3] (Tools.interval 3 3));
        "interval (-5) 2"
        >:: (fun _ -> assert_equal [-5; -4; -3; -2; -1; 0; 1; 2] (Tools.interval (-5) 2));
        "interval 9 3"
        >:: (fun _ -> assert_equal [] (Tools.interval 9 3));

        "list_to_string string_of_int [0; 1; 2]"
        >:: (fun _ -> assert_equal "012" (Tools.list_to_string string_of_int [0; 1; 2]));
        "list_to_string string_of_int []"
        >:: (fun _ -> assert_equal "" (Tools.list_to_string string_of_int []));
        "list_to_string string_of_bool [true; false; true]"
        >::
        (fun _ ->
            assert_equal
                "truefalsetrue"
                (Tools.list_to_string string_of_bool [true; false; true]));
        "list_to_string (fun x -> if x = 0 then \".\" else \"*\") [2; 0; 101; 0; 0]"
        >::
        (fun _ ->
            assert_equal
                "*.*.."
                (Tools.list_to_string
                    (fun x -> if x = 0 then "." else "*")
                    [2; 0; 101; 0; 0]));

        "compose_iter (fun x -> x + 1) 0 5"
        >::
        (fun _ ->
            assert_equal [0; 1; 2; 3; 4; 5] (Tools.compose_iter (fun x -> x + 1) 0 5));
        "compose_iter (fun x -> -x) 8 6"
        >::
        (fun _ ->
            assert_equal [8; -8; 8; -8; 8; -8; 8] (Tools.compose_iter (fun x -> -x) 8 6));
    ]



let _ =
    run_test_tt_main suite_tools

