let rec interval i j =
    if i > j then
        []
    else
        i :: interval (i + 1) j

let list_to_string f lst =
    lst |> List.map f |> String.concat ""

let rec compose_iter f x n =
    if n = 0 then
        [x]
    else
        x :: compose_iter f (f x) (n - 1)

let rec is_prefix_lists lst1 lst2 =
    match lst1, lst2 with
        |[], _ -> true
        |_, [] -> false
        |e1 :: lst1', e2 :: lst2' when e1 = e2 -> is_prefix_lists lst1' lst2'
        |_ -> false

let rec is_factor_lists lst1 lst2 =
    if is_prefix_lists lst1 lst2 then
        true
    else
        match lst2 with
            |[] -> false
            |_ :: lst2' -> is_factor_lists lst1 lst2'

let rec is_subword_lists lst1 lst2 =
    match lst1, lst2 with
        |[], _ -> true
        |_, [] -> false
        |e1 :: lst1', e2 :: lst2' when e1 = e2 -> is_subword_lists lst1' lst2'
        |_, _ :: lst2' -> is_subword_lists lst1 lst2'

let rec is_duplicate_free lst =
    match lst with
        |[] -> true
        |x :: lst' -> (not (List.mem x lst')) && (is_duplicate_free lst')

