let sierpinski =
    let evol (a, b, c) =
        (a + b + c) mod 2
    in
    Automata.create evol 0

type wb = White | Black

let chaos =
    let evol (a, b, c) =
        match a, b, c with
            |Black, Black, Black -> White
            |Black, Black, White -> White
            |Black, White, Black -> White
            |Black, White, White -> Black
            |White, Black, Black -> Black
            |White, Black, White -> Black
            |White, White, Black -> Black
            |White, White, White -> White
    in
    Automata.create evol White


