let evolution aut =
    let ribbon i =
        let tr =
            Automata.get_value aut (i - 1),
            Automata.get_value aut i,
            Automata.get_value aut (i + 1)
        in
        Automata.evol aut tr
    in
    let ribbon = Memoization.memo ribbon in (* With memoization. *)
    {aut with ribbon = ribbon}

let evolutions aut n =
    Tools.compose_iter evolution aut n

let evolutions_bunch aut b n =
    evolutions aut n |> List.map (fun a -> Bunches.get_bunch_values a b)

let is_resurgent aut b n =
    not (Tools.is_duplicate_free (evolutions_bunch aut b n))

let string_representation aut b n val_to_string =
    evolutions_bunch aut b n
    |> List.map (Tools.list_to_string val_to_string)
    |> String.concat "\n"

