type 'a automata = {
    ribbon : int -> 'a;
    evol : 'a * 'a * 'a -> 'a;
    void : 'a
}

let evol aut =
    aut.evol

let create evol void =
    {ribbon = (fun _ -> void); evol = evol; void = void}

let get_value aut i =
    aut.ribbon i

let set_value aut i a =
    let ribbon j =
        if j = i then
            a
        else
            get_value aut j
    in
    {aut with ribbon = ribbon}

let shift aut k =
    {aut with ribbon = fun i -> get_value aut (i + k)}

let mirror aut =
    {aut with ribbon = fun i -> get_value aut (-i)}

let map f aut =
    {aut with ribbon = fun i -> f (get_value aut i)}

