open CellularAutomata

let val_to_string v =
    if v = 0 then "." else "*"

let () =
    if Array.length Sys.argv <> 4 then begin
        Printf.printf "%d arguments are given.\n" (Array.length Sys.argv);
        print_endline "Error: 3 integer arguments are expected.";
        print_endline "The first two specify the bunch and the last one specifies the \
            number of iterations.";
        exit 1
    end;
    let b = (int_of_string Sys.argv.(1), int_of_string Sys.argv.(2)) in
    let n = int_of_string Sys.argv.(3) in
    let aut = Examples.sierpinski in
    let aut = Automata.set_value aut 0 1 in
    Evolutions.string_representation aut b n val_to_string |> print_endline;
    exit 0

